<?php
/**
 * Created by PhpStorm.
 * User: nanadiyusa
 */
    namespace libs\functions;

    use libs\functions\functionAll;

    // setting timezone
    $timezone = "Asia/Jakarta";
    date_default_timezone_set($timezone);

    // koneksi mysql
    class ConnectDB extends FunctionAll
    {
        private $_hostmain;
        private $_usermain;
        private $_passmain;
        private $_dbmain;
        private $_portmain;
        //
        private $query;
        private $mysqli;

        public $_keytoken;
        public $_dateCreate;
        public $_tipedb;

        public $_where;
        public $_selectIn;
        public $_arrdataQuery;
        public $_arrformatQuery;
        public $_table;

        public $_limit = 0;
        public $_batas;

        // fungsi koneksi
        private function connectDBase()
        {
            // konek database
            $this->mysqli = new \mysqli($this->_hostmain, $this->_usermain,
                                        $this->_passmain, $this->_dbmain,
                                        $this->_portmain) or die ('Connection Failed');
            return $this->mysqli;
        }

        // mendapatkan refrensi value dari array
        private function ref_values($array)
        {
            $refs = array();
            foreach ($array as $key => $value) {
                $refs[$key] = &$array[$key];
            }
            return $refs;
        }

        // fungsi select dan crud tabel dengan prepare statement
        protected function scrudSTMT($query, $data, $format, $tipe)
        {
            // tipe database
            if ($this->_tipedb == 'loket') {
                $this->_hostmain = 'pdamsula.com';
                $this->_usermain = 'kabsula_bsinfo';
                $this->_passmain = 'BSINFOsula0418';
                $this->_dbmain = 'kabsula_loket';
                $this->_portmain = '3306';
            } else if ($this->_tipedb == 'bacameter') {
                $this->_hostmain = 'pdamsula.bsamon.com';
                $this->_usermain = 'bacameter';
                $this->_passmain = 'tidaktahu';
                $this->_dbmain = 'bacameter';
                $this->_portmain = '3309';
            }

            // konek database
            $db = $this->connectDBase();

            // prepare query
            $stmt = $db->prepare($query);
            if ($stmt) {
                //
                if ($data != '') {
                    // normalize format
                    $format = implode('', $format); // menggabungkan array dengan pemisah ''
                    $format = str_replace('%', '', $format); // replace %
                    //
                    // menambahkan nilai $format ke dalam $data
                    array_unshift($data, $format);
                    // Dynamically bind values
                    call_user_func_array( array( $stmt, 'bind_param'), $this->ref_values($data));
                }

                $stmt->execute();

                $results = null;

                // jika tipe select
                if ($tipe == 'select') {
                    //
                    $result = $stmt->get_result();
                    // Create results object
                    while ($row = $result->fetch_assoc()) { // fetch_row
                        $results[] = array_map('utf8_encode', $row);
                    }
                }
                // jika tipe crud
                else {
                    if ( $stmt->affected_rows ) {
                        $results = 'oke';
                    } else {
                        $results = 'error';
                    }
                }

                // tutup statements
                $stmt->close();
            } else {
                $results = null;
            }

            // tutup koneksi
            $this->closeDB();
            //
            return $results;
        }

        // fungsi untuk select tabel
        protected function queryAll ()
        {
            $this->query = "SELECT ".$this->_selectIn."
                            FROM ".$this->_table." 
                            ".$this->_where." ";
            return $this->scrudSTMT($this->query, $this->_arrdataQuery, $this->_arrformatQuery, 'select');
        }

        // fungsi close database
        protected function closeDB()
        {
            return $this->mysqli->close();
        }
    }
?>